/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.gamelogic.DialogueBox;
import com.skloch.game.gamelogic.Energy;
import com.skloch.game.gamelogic.EscapeMenu;
import com.skloch.game.gamelogic.EventManager;
import com.skloch.game.gamelogic.GameObject;
import com.skloch.game.gamelogic.NonPlayableCharacter;
import com.skloch.game.gamelogic.Player;
import com.skloch.game.gamelogic.Time;
import com.skloch.game.scoring.Leaderboard;
import com.skloch.game.scoring.Score;
import com.skloch.game.screens.GameOverScreen;
import com.skloch.game.utility.CustomInputAdapter;
import java.util.Arrays;

public class GameScreen
implements Screen {
    final HustleGame game;
    private OrthographicCamera camera;
    public Player player;
    private EscapeMenu escapeMenu;
    private EscapeMenu escapeMenuSetup;
    private Viewport viewport;
    public OrthogonalTiledMapRenderer mapRenderer;
    public Stage uiStage;
    private Label interactionLabel;
    private EventManager eventManager;
    protected InputMultiplexer inputMultiplexer;
    private Table uiTable;
    public DialogueBox dialogueBox;
    public final Image blackScreen;
    public boolean sleeping = false;
    public boolean fadeout = false;
    public float[] campusSpawn;
    public float[] townSpawn;
    public NonPlayableCharacter[] npcs = new NonPlayableCharacter[0];
    private Leaderboard leaderboard;
    public final Score score;
    private final Time time;
    private CustomInputAdapter customInputAdapter;
    String playerName;
    private Energy energyBar;

    public GameScreen(HustleGame game, int avatarChoice, String userInput) {
        this.game = game;
        this.score = Score.getInstance();
        this.playerName = userInput;
        this.time = new Time(this);
        this.player = avatarChoice == 1 ? new Player("avatar1") : new Player("avatar2");
        this.time.hoursSlept = 0;
        this.time.hoursRecreational = 0;
        this.time.hoursStudied = 0;
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.width + 550, (float)(game.height + 300), this.camera);
        Energy energyBar = new Energy(this.viewport);
        this.camera.setToOrtho(false, game.width, game.height);
        game.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.eventManager = new EventManager(this, energyBar, this.time, this.player);
        this.leaderboard = new Leaderboard();
        this.uiStage = new Stage(new FitViewport(game.width, game.height));
        this.blackScreen = new Image(new Texture(Gdx.files.internal("Sprites/black_square.png")));
        this.blackScreen.setSize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
        this.blackScreen.addAction(Actions.alpha(0.0f));
        this.uiTable = new Table();
        this.uiTable.setSize(game.width, game.height);
        this.uiStage.addActor(this.uiTable);
        this.interactionLabel = new Label("E - Interact", game.skin, "default");
        this.dialogueBox = new DialogueBox(game.skin, this.player);
        this.dialogueBox.setPos((this.viewport.getWorldWidth() - this.dialogueBox.getWidth()) / 2.0f - 275.0f, 15.0f);
        this.dialogueBox.hide();
        this.time.daySeconds = 480.0f;
        Table timeTable = new Table();
        timeTable.setFillParent(true);
        this.time.timeLabel = new Label(Time.formatTime((int)this.time.daySeconds), game.skin, "time");
        this.time.dayLabel = new Label(String.format("Day %d", this.time.day), game.skin, "day");
        timeTable.add(this.time.timeLabel).uniformX();
        timeTable.row();
        timeTable.add(this.time.dayLabel).uniformX().left().padTop(2.0f);
        timeTable.top().left().padLeft(10.0f).padTop(10.0f);
        this.uiTable.add(this.interactionLabel).padTop(300.0f);
        this.uiStage.addActor(energyBar);
        this.uiStage.addActor(timeTable);
        this.uiStage.addActor(this.blackScreen);
        this.uiStage.addActor(this.dialogueBox.getWindow());
        this.uiStage.addActor(this.dialogueBox.getSelectBox().getWindow());
        this.escapeMenu = new EscapeMenu(this.game, this.viewport, this, this.uiStage);
        game.soundManager.playOverworldMusic();
        this.customInputAdapter = new CustomInputAdapter(this.game, this.dialogueBox, this.eventManager, this.player, EscapeMenu.escapeMenu, this);
        InputAdapter gameKeyBoardInput = this.customInputAdapter.makeInputAdapter();
        this.inputMultiplexer = new InputMultiplexer();
        this.inputMultiplexer.addProcessor(gameKeyBoardInput);
        this.inputMultiplexer.addProcessor(this.uiStage);
        Gdx.input.setInputProcessor(this.inputMultiplexer);
        float unitScale = game.mapScale / (float)game.mapSquareSize;
        this.mapRenderer = new OrthogonalTiledMapRenderer(game.map, unitScale);
        TiledMapTileLayer layer0 = (TiledMapTileLayer)game.map.getLayers().get(0);
        this.player.setPos((float)layer0.getWidth() * game.mapScale / 2.0f, (float)layer0.getHeight() * game.mapScale / 2.0f);
        this.camera.position.set(this.player.getCentreX(), this.player.getCentreY(), 0.0f);
        for (int layer : game.objectLayers) {
            MapObjects objects = game.map.getLayers().get(layer).getObjects();
            for (int i = 0; i < objects.getCount(); ++i) {
                MapProperties properties = objects.get(i).getProperties();
                if (properties.get("npc") != null) {
                    String avatar = (String)properties.get("avatar");
                    int direction = (Integer)properties.get("direction");
                    this.npcs = Arrays.copyOf(this.npcs, this.npcs.length + 1);
                    this.npcs[this.npcs.length - 1] = new NonPlayableCharacter(avatar, direction);
                    this.npcs[this.npcs.length - 1].setPos(((Float)properties.get("x")).floatValue() * unitScale, ((Float)properties.get("y")).floatValue() * unitScale);
                }
                if (properties.get("spawn") != null) {
                    this.player.setPos(((Float)properties.get("x")).floatValue() * unitScale, ((Float)properties.get("y")).floatValue() * unitScale);
                    this.camera.position.set(this.player.getPosAsVec3());
                    continue;
                }
                if (properties.get("spawnCampus") != null) {
                    this.campusSpawn = new float[]{((Float)properties.get("x")).floatValue() * unitScale, ((Float)properties.get("y")).floatValue() * unitScale};
                    continue;
                }
                if (properties.get("spawnTown") != null) {
                    this.townSpawn = new float[]{((Float)properties.get("x")).floatValue() * unitScale, ((Float)properties.get("y")).floatValue() * unitScale};
                    continue;
                }
                this.player.addCollidable(new GameObject(properties, unitScale));
            }
        }
        this.player.setBounds(new Rectangle(0.0f, 0.0f, (float)game.mapProperties.get("width", Integer.class).intValue() * game.mapScale, (float)game.mapProperties.get("height", Integer.class).intValue() * game.mapScale));
        game.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.dialogueBox.show();
        this.dialogueBox.setText(this.time.getWakeUpMessage());
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.viewport.apply();
        delta = 0.016667f;
        this.game.soundManager.processTimers(delta);
        this.time.timeLabel.setText(Time.formatTime((int)this.time.daySeconds));
        if (EscapeMenu.escapeMenu.isVisible() || this.dialogueBox.isVisible() || this.sleeping || this.fadeout) {
            this.player.setFrozen(true);
        } else {
            this.player.setFrozen(false);
        }
        this.dialogueBox.scrollText(0.8f);
        this.player.move(delta);
        if (this.player.isRunning()) {
            this.game.soundManager.playFootstep(0.25f);
        } else if (this.player.isMoving()) {
            this.game.soundManager.playFootstep(0.5f);
        } else {
            this.game.soundManager.footstepBool = false;
        }
        this.mapRenderer.setView(this.camera);
        this.mapRenderer.render(this.game.backgroundLayers);
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.game.batch.begin();
        for (NonPlayableCharacter npc : this.npcs) {
            npc.updateAnimation();
            this.game.batch.draw(npc.getCurrentFrame(), npc.sprite.x, npc.sprite.y, 0.0f, 0.0f, npc.sprite.width, npc.sprite.height, 1.0f, 1.0f, 1.0f);
        }
        this.game.batch.draw(this.player.getCurrentFrame(), this.player.sprite.x, this.player.sprite.y, 0.0f, 0.0f, this.player.sprite.width, this.player.sprite.height, 1.0f, 1.0f, 1.0f);
        this.game.batch.end();
        this.mapRenderer.render(this.game.foregroundLayers);
        this.interactionLabel.setVisible(false);
        if (!(this.dialogueBox.isVisible() || EscapeMenu.escapeMenu.isVisible() || this.sleeping || this.fadeout || !this.player.nearObject())) {
            this.interactionLabel.setVisible(true);
            if (this.player.getClosestObject().get("npc") != null) {
                this.interactionLabel.setText("E - Talk");
            } else if (this.player.getClosestObject().get("event") != null) {
                this.interactionLabel.setText("E - Interact");
            } else if (this.player.getClosestObject().get("text") != null) {
                this.interactionLabel.setText("E - Read Sign");
            }
        }
        this.uiStage.getViewport().apply();
        this.uiStage.act(delta);
        this.uiStage.draw();
        this.camera.position.slerp(new Vector3(this.player.getCentreX(), this.player.getCentreY(), 0.0f), delta * 9.0f);
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.uiStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
        Gdx.input.setInputProcessor(this.inputMultiplexer);
        Gdx.input.setCursorPosition(Gdx.input.getX(), Gdx.input.getY());
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.uiStage.dispose();
        this.mapRenderer.dispose();
    }

    public void setSleeping(boolean sleeping) {
        this.sleeping = sleeping;
    }

    public boolean getSleeping() {
        return this.sleeping;
    }

    public void setFadeout(boolean fadeout) {
        this.fadeout = fadeout;
    }

    public boolean getFadeout() {
        return this.fadeout;
    }

    public void gameOver() {
        this.game.setScreen(new GameOverScreen(this.game));
        int totalScore = this.score.getTotalScore();
        this.leaderboard.saveScore(this.playerName, totalScore);
    }

    public void hideDialogueSelectBox() {
        this.dialogueBox.hideSelectBox();
    }

    public void showDialogueBox() {
        this.dialogueBox.show();
    }

    public void hideDialogueBox() {
        this.dialogueBox.hide();
    }

    public void setDialogueBoxText(String text) {
        this.dialogueBox.setText(text);
    }

    public void setDialogueBoxText(String text, String eventKey) {
        this.dialogueBox.setText(text, eventKey);
    }

    public void setDialogueBoxOptions(String[] options, String[] events) {
        this.dialogueBox.getSelectBox().setOptions(options, events);
    }

    public void addActionToBlackscreen(Action action) {
        this.blackScreen.addAction(action);
    }

    public void updateDay(Label label, String text) {
        label.setText(text);
    }
}

